/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.collectors.components.ErrorNodeDiagnosticCollectorComponent;
import org.jetbrains.kotlin.fir.diagnostics.ConeCannotInferType;
import org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic;
import org.jetbrains.kotlin.fir.diagnostics.ConeSimpleDiagnostic;
import org.jetbrains.kotlin.fir.diagnostics.DiagnosticKind;
import org.jetbrains.kotlin.fir.diagnostics.FirDiagnosticHolder;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import org.jetbrains.kotlin.fir.expressions.FirBlock;
import org.jetbrains.kotlin.fir.expressions.FirCheckedSafeCallSubject;
import org.jetbrains.kotlin.fir.expressions.FirDesugaredAssignmentValueReferenceExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirResolvable;
import org.jetbrains.kotlin.fir.expressions.FirSafeCallExpression;
import org.jetbrains.kotlin.fir.expressions.FirSmartCastExpression;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.FirThisReceiverExpression;
import org.jetbrains.kotlin.fir.expressions.FirTypeOperatorCall;
import org.jetbrains.kotlin.fir.expressions.FirWhenExpression;
import org.jetbrains.kotlin.fir.expressions.FirWhenSubjectExpression;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.references.FirSuperReference;
import org.jetbrains.kotlin.fir.references.impl.FirStubReference;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.types.ConeErrorType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirErrorTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionWithErrorTypeChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirBasicExpressionChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "expression", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/expressions/FirStatement;)V", "checkers"})
public final class FirExpressionWithErrorTypeChecker
extends FirExpressionChecker<FirStatement> {
    @NotNull
    public static final FirExpressionWithErrorTypeChecker INSTANCE = new FirExpressionWithErrorTypeChecker();

    private FirExpressionWithErrorTypeChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirStatement expression2) {
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        Intrinsics.checkNotNullParameter(expression2, "expression");
        if (!(expression2 instanceof FirExpression)) {
            return;
        }
        ConeKotlinType type = FirTypeUtilsKt.getResolvedType((FirExpression)expression2);
        if (!(type instanceof ConeErrorType)) {
            return;
        }
        if (expression2 instanceof FirBlock) {
            return;
        }
        if (expression2 instanceof FirSafeCallExpression) {
            return;
        }
        if (expression2 instanceof FirDesugaredAssignmentValueReferenceExpression || expression2 instanceof FirWhenSubjectExpression || expression2 instanceof FirSmartCastExpression || expression2 instanceof FirCheckedSafeCallSubject) {
            return;
        }
        if (expression2 instanceof FirDiagnosticHolder) {
            return;
        }
        if (expression2 instanceof FirResolvable) {
            FirReference calleeReference = ((FirResolvable)((Object)expression2)).getCalleeReference();
            if (calleeReference instanceof FirDiagnosticHolder) {
                return;
            }
            if (calleeReference instanceof FirSuperReference && ((FirSuperReference)calleeReference).getSuperTypeRef() instanceof FirErrorTypeRef) {
                return;
            }
            if (calleeReference instanceof FirResolvedNamedReference) {
                FirCallableSymbol symbol;
                FirBasedSymbol<?> firBasedSymbol = FirReferenceUtilsKt.getSymbol(calleeReference);
                FirCallableSymbol firCallableSymbol = symbol = firBasedSymbol instanceof FirCallableSymbol ? (FirCallableSymbol)firBasedSymbol : null;
                if ((firCallableSymbol != null ? firCallableSymbol.getResolvedReturnTypeRef() : null) instanceof FirErrorTypeRef) {
                    return;
                }
            }
        }
        if (expression2 instanceof FirThisReceiverExpression && ((FirThisReceiverExpression)expression2).getCalleeReference().getDiagnostic() != null) {
            return;
        }
        if (expression2 instanceof FirAnnotationCall && ((FirAnnotationCall)expression2).getAnnotationTypeRef() instanceof FirErrorTypeRef) {
            return;
        }
        if (expression2 instanceof FirTypeOperatorCall && ((FirTypeOperatorCall)expression2).getConversionTypeRef() instanceof FirErrorTypeRef) {
            return;
        }
        if (expression2 instanceof FirWhenExpression && ((FirWhenExpression)expression2).getCalleeReference() instanceof FirStubReference) {
            return;
        }
        KtSourceElement source = ((FirExpression)expression2).getSource();
        if (source != null) {
            ConeDiagnostic diagnostic = ((ConeErrorType)type).getDiagnostic();
            if (diagnostic instanceof ConeCannotInferType) {
                return;
            }
            if (diagnostic instanceof ConeSimpleDiagnostic) {
                switch (WhenMappings.$EnumSwitchMapping$0[((ConeSimpleDiagnostic)diagnostic).getKind().ordinal()]) {
                    case 1: {
                        return;
                    }
                    case 2: {
                        return;
                    }
                    case 3: {
                        return;
                    }
                }
            }
            ErrorNodeDiagnosticCollectorComponent.Companion.reportFirDiagnostic$checkers$default(ErrorNodeDiagnosticCollectorComponent.Companion, ((ConeErrorType)type).getDiagnostic(), source, context2, null, reporter, null, null, 104, null);
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DiagnosticKind.values().length];
            try {
                nArray[DiagnosticKind.RecursionInImplicitTypes.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DiagnosticKind.RecursiveTypealiasExpansion.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DiagnosticKind.UnsignedNumbersAreNotPresent.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

