/*
 * Decompiled with CFR 0.152.
 */
package org.ditang.relaxng.defaults;

import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.StringTokenizer;

public class Util {
    private static Boolean windows = null;
    private static final boolean[] gNeedEscaping = new boolean[128];
    private static final char[] gAfterEscaping1 = new char[128];
    private static final char[] gAfterEscaping2 = new char[128];
    private static final char[] gHexChs = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private static boolean isWindows() {
        if (windows == null) {
            windows = System.getProperty("os.name").toUpperCase().startsWith("WIN");
        }
        return windows;
    }

    private static String filepath2URI(String path) {
        if (path == null) {
            return null;
        }
        path = Util.escapeSpecialAsciiAndNonAscii(path);
        return path;
    }

    private static String escapeSpecialAsciiAndNonAscii(String path) {
        int ch;
        int len = path.length();
        StringBuilder buffer = new StringBuilder(len * 3);
        if (len >= 2 && path.charAt(1) == ':' && (ch = Character.toUpperCase(path.charAt(0))) >= 65 && ch <= 90) {
            buffer.append('/');
        }
        int i = 0;
        for (i = 0; i < len && (ch = path.charAt(i)) < 128; ++i) {
            if (gNeedEscaping[ch]) {
                buffer.append('%');
                buffer.append(gAfterEscaping1[ch]);
                buffer.append(gAfterEscaping2[ch]);
                continue;
            }
            buffer.append((char)ch);
        }
        if (i < len) {
            byte[] bytes = null;
            for (byte b : path.substring(i).getBytes(StandardCharsets.UTF_8)) {
                if (b < 0) {
                    ch = b + 256;
                    buffer.append('%');
                    buffer.append(gHexChs[ch >> 4]);
                    buffer.append(gHexChs[ch & 0xF]);
                    continue;
                }
                if (gNeedEscaping[b]) {
                    buffer.append('%');
                    buffer.append(gAfterEscaping1[b]);
                    buffer.append(gAfterEscaping2[b]);
                    continue;
                }
                buffer.append((char)b);
            }
        }
        return buffer.toString();
    }

    public static URL correct(URL url) throws MalformedURLException {
        if (url == null) {
            throw new MalformedURLException("The url is null");
        }
        return new URL(Util.correct(url.toString()));
    }

    private static String correct(String url) {
        URL urlWithoutUserInfo;
        if (((String)url).startsWith("file://") && !((String)url).startsWith("file:///") && Util.isWindows()) {
            url = "file:////" + ((String)url).substring("file://".length());
        }
        String userInfo = Util.getUserInfo((String)url);
        String user = Util.extractUser(userInfo);
        String pass = Util.extractPassword(userInfo);
        String initialUrl = url;
        if ((user != null || pass != null) && (urlWithoutUserInfo = Util.clearUserInfo((String)url)) != null) {
            url = Util.clearUserInfo((String)url).toString();
        }
        if (((String)url).contains("%")) {
            return initialUrl;
        }
        String reference = null;
        int refIndex = ((String)url).lastIndexOf(35);
        if (refIndex != -1) {
            reference = Util.filepath2URI(((String)url).substring(refIndex + 1));
            url = ((String)url).substring(0, refIndex);
        }
        StringBuilder queryBuffer = null;
        int queryIndex = ((String)url).indexOf(63);
        if (queryIndex != -1) {
            String query = ((String)url).substring(queryIndex + 1);
            url = ((String)url).substring(0, queryIndex);
            queryBuffer = new StringBuilder(query.length());
            StringTokenizer st = new StringTokenizer(query, "&");
            while (st.hasMoreElements()) {
                String token = st.nextToken();
                token = Util.filepath2URI(token);
                queryBuffer.append(token);
                if (!st.hasMoreElements()) continue;
                queryBuffer.append("&");
            }
        }
        Object toReturn = Util.filepath2URI((String)url);
        if (queryBuffer != null) {
            toReturn = (String)toReturn + "?" + queryBuffer.toString();
        }
        if (reference != null) {
            toReturn = (String)toReturn + "#" + reference;
        }
        if (user != null || pass != null) {
            try {
                if (user == null) {
                    user = "";
                }
                if (pass == null) {
                    pass = "";
                }
                toReturn = Util.attachUserInfo(new URL((String)toReturn), user, pass.toCharArray()).toString();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return toReturn;
    }

    private static String getUserInfo(String url) {
        String userInfo = null;
        int startIndex = Integer.MIN_VALUE;
        int nextSlashIndex = Integer.MIN_VALUE;
        int endIndex = Integer.MIN_VALUE;
        try {
            startIndex = url.indexOf("//");
            if (startIndex != -1) {
                nextSlashIndex = url.indexOf(47, startIndex += 2);
                if (nextSlashIndex == -1) {
                    nextSlashIndex = url.length();
                }
                if ((endIndex = url.substring(startIndex, nextSlashIndex).lastIndexOf(64)) != -1) {
                    userInfo = url.substring(startIndex, startIndex + endIndex);
                }
            }
        }
        catch (StringIndexOutOfBoundsException ex) {
            System.err.println("String index out of bounds for:|" + url + "|");
            System.err.println("Start index: " + startIndex);
            System.err.println("Next slash index " + nextSlashIndex);
            System.err.println("End index :" + endIndex);
            System.err.println("User info :|" + userInfo + "|");
            ex.printStackTrace();
        }
        return userInfo;
    }

    private static String extractUser(String userInfo) {
        if (userInfo == null) {
            return null;
        }
        int index = userInfo.lastIndexOf(58);
        if (index == -1) {
            return userInfo;
        }
        return userInfo.substring(0, index);
    }

    private static String extractPassword(String userInfo) {
        if (userInfo == null) {
            return null;
        }
        String password = "";
        int index = userInfo.lastIndexOf(58);
        if (index != -1 && index < userInfo.length() - 1) {
            password = userInfo.substring(index + 1);
        }
        return password;
    }

    private static URL clearUserInfo(String systemID) {
        try {
            URL url = new URL(systemID);
            if (!"file".equals(url.getProtocol())) {
                return Util.attachUserInfo(url, null, null);
            }
            return url;
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    private static URL attachUserInfo(URL url, String user, char[] password) throws MalformedURLException {
        if (url == null) {
            return null;
        }
        if ((url.getAuthority() == null || "".equals(url.getAuthority())) && !"jar".equals(url.getProtocol())) {
            return url;
        }
        StringBuilder buf = new StringBuilder();
        String protocol = url.getProtocol();
        if (protocol.equals("jar")) {
            URL newURL = new URL(url.getPath());
            newURL = Util.attachUserInfo(newURL, user, password);
            buf.append("jar:");
            buf.append(newURL.toString());
        } else {
            String ref;
            password = Util.correctPassword(password);
            user = Util.correctUser(user);
            buf.append(protocol);
            buf.append("://");
            if (!"file".equals(protocol) && user != null && user.trim().length() > 0) {
                buf.append(user);
                if (password != null && password.length > 0) {
                    buf.append(":");
                    buf.append(password);
                }
                buf.append("@");
            }
            buf.append(url.getHost());
            if (url.getPort() > 0) {
                buf.append(":");
                buf.append(url.getPort());
            }
            buf.append(url.getPath());
            String query = url.getQuery();
            if (query != null && query.trim().length() > 0) {
                buf.append("?").append(query);
            }
            if ((ref = url.getRef()) != null && ref.trim().length() > 0) {
                buf.append("#").append(ref);
            }
        }
        return new URL(buf.toString());
    }

    private static String correctUser(String user) {
        if (user != null && user.trim().length() > 0 && user.indexOf(37) == -1) {
            String escaped = Util.escapeSpecialAsciiAndNonAscii(user);
            StringBuilder totalEscaped = new StringBuilder();
            for (int i = 0; i < escaped.length(); ++i) {
                char ch = escaped.charAt(i);
                if (ch == '@' || ch == '/' || ch == ':') {
                    totalEscaped.append('%').append(Integer.toHexString(ch).toUpperCase());
                    continue;
                }
                totalEscaped.append(ch);
            }
            user = totalEscaped.toString();
        }
        return user;
    }

    private static char[] correctPassword(char[] password) {
        if (password != null && new String(password).indexOf(37) == -1) {
            String escaped = Util.escapeSpecialAsciiAndNonAscii(new String(password));
            StringBuilder totalEscaped = new StringBuilder();
            for (int i = 0; i < escaped.length(); ++i) {
                char ch = escaped.charAt(i);
                if (ch == '@' || ch == '/' || ch == ':') {
                    totalEscaped.append('%').append(Integer.toHexString(ch).toUpperCase());
                    continue;
                }
                totalEscaped.append(ch);
            }
            password = totalEscaped.toString().toCharArray();
        }
        return password;
    }

    static {
        for (int i = 0; i <= 31; ++i) {
            Util.gNeedEscaping[i] = true;
            Util.gAfterEscaping1[i] = gHexChs[i >> 4];
            Util.gAfterEscaping2[i] = gHexChs[i & 0xF];
        }
        Util.gNeedEscaping[127] = true;
        Util.gAfterEscaping1[127] = 55;
        Util.gAfterEscaping2[127] = 70;
        char[] escChs = new char[]{' ', '<', '>', '#', '%', '\"', '{', '}', '?', '|', '\\', '^', '~', '[', ']', '`', '\'', '&'};
        int len = escChs.length;
        char[] cArray = escChs;
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            char escCh;
            char ch = escCh = cArray[i];
            Util.gNeedEscaping[ch] = true;
            Util.gAfterEscaping1[ch] = gHexChs[ch >> 4];
            Util.gAfterEscaping2[ch] = gHexChs[ch & 0xF];
        }
    }
}

