/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pdf.pdfbox;

import java.io.IOException;
import org.apache.fop.pdf.PDFDocument;
import org.apache.fop.pdf.PDFName;
import org.apache.fop.pdf.PDFPage;
import org.apache.fop.pdf.PDFStructElem;
import org.apache.fop.render.pdf.PDFLogicalStructureHandler;
import org.apache.fop.render.pdf.pdfbox.DocumentRootModifier;
import org.apache.fop.render.pdf.pdfbox.PDFBoxAdapter;
import org.apache.fop.render.pdf.pdfbox.PageParentTreeFinder;
import org.apache.fop.render.pdf.pdfbox.StructureTreeMerger;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.documentinterchange.logicalstructure.PDMarkInfo;

public class TaggedPDFConductor {
    private PDPage srcPage;
    private PDFPage targetPage;
    private DocumentRootModifier rootMod;
    private StructureTreeMerger merger;

    public TaggedPDFConductor(PDFStructElem currentSessionElem, PDFLogicalStructureHandler logicalStructHandler, PDPage srcPage, PDFBoxAdapter adapter) {
        this.srcPage = srcPage;
        this.targetPage = adapter.getTargetPage();
        PDFDocument pdfDoc = this.targetPage.getDocument();
        this.rootMod = new DocumentRootModifier(adapter, pdfDoc);
        this.merger = new StructureTreeMerger(currentSessionElem, logicalStructHandler, adapter, srcPage);
    }

    public void handleLogicalStructure(PDDocument srcDoc) throws IOException {
        if (this.isInputPDFTagged(srcDoc) && this.isStructureTreeRootNull(srcDoc)) {
            this.merger.setCurrentSessionElem();
            COSDictionary strucRootDict = srcDoc.getDocumentCatalog().getStructureTreeRoot().getCOSObject();
            this.rootMod.structTreeRootEntriesToCopy(strucRootDict);
            if (!this.isParentTreeIsPresent(strucRootDict)) {
                this.merger.createDirectDescendants((COSBase)strucRootDict, this.merger.getCurrentSessionElem());
            } else {
                PageParentTreeFinder markedContentsParentFinder = new PageParentTreeFinder(this.srcPage);
                COSArray markedContentsParents = markedContentsParentFinder.getPageParentTreeArray(srcDoc);
                COSDictionary roleMap = (COSDictionary)strucRootDict.getDictionaryObject(COSName.ROLE_MAP);
                if (roleMap != null) {
                    this.merger.setRoleMap(roleMap);
                }
                this.merger.copyStructure(markedContentsParents);
            }
        }
        this.configureCurrentSessionElem(srcDoc);
    }

    private void configureCurrentSessionElem(PDDocument srcDoc) {
        if (!this.isInputPDFTagged(srcDoc) || !this.isStructureTreeRootNull(srcDoc)) {
            this.merger.setCurrentSessionElemKid();
            this.merger.getCurrentSessionElem().put(COSName.PG.getName(), (Object)this.targetPage.makeReference());
        } else {
            this.merger.getCurrentSessionElem().put("S", (Object)new PDFName("Div"));
            this.merger.getCurrentSessionElem().remove("Alt");
        }
    }

    private boolean isInputPDFTagged(PDDocument srcDoc) {
        PDMarkInfo mark = srcDoc.getDocumentCatalog().getMarkInfo();
        return mark != null && mark.isMarked();
    }

    private boolean isStructureTreeRootNull(PDDocument srcDoc) {
        return srcDoc.getDocumentCatalog().getStructureTreeRoot() != null;
    }

    private boolean isParentTreeIsPresent(COSDictionary strucRootDict) {
        return strucRootDict.keySet().contains(COSName.PARENT_TREE);
    }
}

